/* 

ui.js  

*/

function updateSelectStyle(el) {
	var elContainer = document.getElementById(el);
	var elSelectForm = document.getElementById(el + '_form');
	var elSelectList = document.getElementById(el + '_list');
	
	if (!elSelectList || !elSelectForm || !elContainer ) {
		return;
	}
	setClass(elSelectForm, 'hide');
	createDropdownList(el, elContainer,elSelectList);
}

function createDropdownList(el, elContainer,elSelectList) {
	var elList = document.createElement('ul');
	var elListSelections = document.createElement('ul');
	var elTitle = document.createElement('li');
	var elOptions = '';
	var i, j = 0;
	
	if (el == 'select_product' ) {
		elList.setAttribute('id','dropdown_list');
	} else {
		elList.setAttribute('id','dropdown_list_store');
	}
	setClass(elList, 'dropdown_list');
	
	for (i = 0; i < elSelectList.options.length; i++) {
		if (j == 0) {
			elTitle.innerHTML = '<h3><span>' + elSelectList.options[i].innerHTML + '</span></h3>';
		} else {
			elOptions = elOptions + '<li><a href="' + elSelectList.options[i].value + '">' + elSelectList.options[i].innerHTML + '</a></li>';
		}
		j++;
	}
		
	elListSelections.innerHTML = elOptions;
	elTitle.appendChild(elListSelections);
	elList.appendChild(elTitle);
	
	/* add scrollbar to menu if it has too many links */
	if (j > 5) {
		setClass(elListSelections, 'scroll');
	}
	
	elContainer.appendChild(elList);
}

function showHideList(el){
	var elList = document.getElementById(el);
	/* do nothing if dropdown list is not found */
	if (!elList) {
		return;
	}
	
	/* on mouse over show list */
	elList.onmouseover = function(e) {
		toggleList(this,'show');
	}
	
	/* on mouse out hide list */
	if (el == 'dropdown_list' ) {
		elList.onmouseout = onMouseLeave(leaveHandlerProduct);
	} else {
		elList.onmouseout = onMouseLeave(leaveHandlerStore);
	}
}
function leaveHandlerProduct(){
	var el = document.getElementById('dropdown_list');
	toggleList(el,'hide');
}

function leaveHandlerStore(){
	var el = document.getElementById('dropdown_list_store');
	toggleList(el,'hide');
}

//Note that a mouseout/over event is always fired before a mouseleave/enter event
//Also note that mouseleave/enter events do not bubble; effectively, they don't bubble in this implementation either.
//usage:  elem.onmouseout = onMouseLeave(leaveHandler, outHandler);
//usage:  elem.onmouseover = onMouseEnter(enterHandler, overHandler);
function onMouseLeave(handleLeave, handleOut)
{
	if(!handleLeave) return handleOut;
	return function(evt)
	{
		evt = evt || window.event;
		if(handleOut) handleOut.call(this, evt);
		try{
			var mbc = new MouseBoundaryCrossing(evt, this);
			if(mbc.leftLandmark) handleLeave.call(this, evt);
		}catch(e){}
	}
}

//since mouseenter & mouseleave are only supported in IE, this object helps to
// determine if the mouse is entering or leaving an element
//landmark: did the mouse enter or leave this "landmark" element? Was the event fired from within this element?
//usage:   var mbc = new MouseBoundaryCrossing(mouse_event, landmark);
function MouseBoundaryCrossing(evt, landmark)
{
	evt = evt || window.event;
	
	var eventType = evt.type;
	
	this.inLandmark = false;
	this.leftLandmark = false;
	this.enteredLandmark = false;
	
	if(eventType == "mouseout")
	{
		this.toElement = evt.relatedTarget || evt.toElement;
		this.fromElement = evt.target || evt.srcElement;
	}
	else if(eventType == "mouseover")
	{
		this.toElement = evt.target || evt.srcElement;
		this.fromElement = evt.relatedTarget || evt.fromElement;
	}
	else throw (new Error("Event type \""+eventType+"\" is irrelevant"));	//irrelevant event type
	
	//target is unknown
	//this seems to happen on the mouseover event when the mouse is already inside the element when the page loads and
	// the mouse is moved: fromElement is undefined
	if(!this.toElement || !this.fromElement) throw (new Error("Event target(s) undefined"));
	
	//determine whether from-element is inside or outside of landmark (i.e., does tmpFrom == the landmark or the document?)
	var tmpFrom = this.fromElement;
	while(tmpFrom.nodeType == 1)	//while tmpFrom is an element node
	{
		if(tmpFrom == landmark) break;
		tmpFrom = tmpFrom.parentNode;
	}
	
	//determine whether to-element is inside or outside of landmark (i.e., does tmpTo == the landmark or the document?)
	var tmpTo = this.toElement;
	while(tmpTo.nodeType == 1)	//while tmpTo is an element node
	{
		if(tmpTo == landmark) break;
		tmpTo = tmpTo.parentNode;
	}
	
	if(tmpFrom == landmark && tmpTo == landmark) this.inLandmark = true;	//mouse is inside landmark; didn't enter or leave
	else if(tmpFrom == landmark && tmpTo != landmark)	//mouse left landmark
	{
		this.leftLandmark = true;
		this.inLandmark = (eventType == "mouseout");	//mouseout: currently inside landmark, but leaving now
														//mouseover: currently outside of landmark; just left
	}
	else if(tmpFrom != landmark && tmpTo == landmark)	//mouse entered landmark
	{
		this.enteredLandmark = true;
		this.inLandmark = (eventType == "mouseover");	//mouseover: currently inside landmark; just entered
														//mouseout: currently outside of landmark, but entering now
	}
	//else	//mouse is outside of landmark; didn't enter or leave
}

function toggleList(elList,type) {
	for (var i = 0; i < elList.childNodes.length; i++) {
		if (elList.childNodes[i].nodeName == 'LI') {
			var elTemp = elList.childNodes[i];
			for (var j = 0; j < elTemp.childNodes.length; j++) {
				if (elTemp.childNodes[j].nodeName == 'UL') {
					if (type == 'show') {						
						setClass(elTemp.childNodes[j], 'show');
					} else {
						removeClass(elTemp.childNodes[j], 'show');
					}
				}
			}
		}
	}
}

function textSize() {
	var el = document.getElementById('font_size');
	if (!el) {
		return;
	}
	
	var elContent = el.innerHTML;	
	el.innerHTML = elContent + '<a href="#" id="font_decrease">A-</a><a href="#" id="font_increase">A+</a>';
	
	var elDecrease = document.getElementById('font_decrease');
	var elIncrease = document.getElementById('font_increase');
	var elBody = document.getElementsByTagName('body');
	
	// if cookie is set use large font
	if (readCookie('textsize')) {
		setClass(elBody[0], 'large_font');
	}
	
	elDecrease.onclick = function() {
		// delete cookie
		eraseCookie('textsize');
		removeClass(elBody[0], 'large_font');
		
		return false;
	}
	elIncrease.onclick = function() {
		//create cookie
		createCookie('textsize','large')
		setClass(elBody[0], 'large_font');	
		return false;
	};
}

Initializers.add(function(){textSize()});
Initializers.add(function(){updateSelectStyle('select_product')});
Initializers.add(function(){updateSelectStyle('select_store')});
Initializers.add(function(){showHideList('dropdown_list')});
Initializers.add(function(){showHideList('dropdown_list_store')});