/* 

core.js  


*/

/*
 * Adds handler to window.onload event.
 */

Initializers = {
	callbacks: [],
	windowLoaded: false,

	add: function(func)
	{
		if (typeof func == 'function')
			Initializers.callbacks.push(func);
	},

	run: function()
	{
		for (var i = 0; i < Initializers.callbacks.length; i++) {
			try {
				Initializers.callbacks[i]();
			}
			catch (err) {
				return;
				/*alert('An error occured when calling an initializer. Reason: ' + err +
					'\n\nInitializer code:\n\n' + Initializers.callbacks[i]);
				*/
			}
		}
	},

	Events: {
		onWindowLoad: function() {
			if (Initializers.windowLoaded)
				return;

			Initializers.windowLoaded = true;
			Initializers.run();
		}
	}
};

window.onload = Initializers.Events.onWindowLoad;

if (document.addEventListener)
	document.addEventListener('DOMContentLoaded', Initializers.Events.onWindowLoad, null);


/*
 * Escapes regular expression meta characters from given string.
 */
String.prototype.escapeRxSpecials = function()
{
	return this.replace(/([.*+?^${}()|[\]\/\\])/g, '\\$1');
}


/*
 * Returns true if the node has CSS class with given name; otherwise returns false.
 */
function hasClass(node, className)
{
	return new RegExp('\\b' + className.escapeRxSpecials() + '\\b').exec(node.className);
}

function setClass(node, className)
{
	if (!hasClass(node, className))
		node.className = className + (node.className.length > 0 ? ' ': '') + node.className;

	return node;
}


function removeClass(node, className)
{
	var classNames = node.className.split(/\s+/);

	for (var i = 0; i < classNames.length; i++) {
		if (classNames[i] == className) {
			classNames.splice(i, 1);
			node.className = classNames.join(' ');
			break;
		}
	}

	return node;
}

function cEl(el) {
	return document.createElement(el);
}

function getNextSibling(startBrother){
	endBrother=startBrother.nextSibling;

	while(endBrother && endBrother.nodeType!=1){
		endBrother = endBrother.nextSibling;
	}

	return endBrother || null;
}

function createCookie(name,value,days) {
	if (days) {
		var date = new Date();
		date.setTime(date.getTime()+(days*24*60*60*1000));
		var expires = "; expires="+date.toGMTString();
	}
	else var expires = "";
	document.cookie = name+"="+value+expires+"; path=/";
}

function readCookie(name) {
	var nameEQ = name + "=";
	var ca = document.cookie.split(';');
	for(var i=0;i < ca.length;i++) {
		var c = ca[i];
		while (c.charAt(0)==' ') c = c.substring(1,c.length);
		if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
	}
	return null;
}

function eraseCookie(name) {
	createCookie(name,"",-1);
}
