/**
 * Function : dump()
 * Arguments: The data - array,hash(associative array),object
 *    The level - OPTIONAL
 * Returns  : The textual representation of the array.
 * This function was inspired by the print_r function of PHP.
 * This will accept some data as the argument and return a
 * text that will be a more readable version of the
 * array/hash/object that is given.
 * Docs: http://www.openjs.com/scripts/others/dump_function_php_print_r.php
 */
//Replaces all instances of the given substring.
String.prototype.replaceAll = function( 
	strTarget, // The substring you want to replace
	strSubString // The string you want to replace in.
	){
	var strText = this;
	var intIndexOfMatch = strText.indexOf( strTarget );
	 
	// Keep looping while an instance of the target string
	// still exists in the string.
	while (intIndexOfMatch != -1){
		// Relace out the current instance.
		strText = strText.replace( strTarget, strSubString )
		 
		// Get the index of any next matching substring.
		intIndexOfMatch = strText.indexOf( strTarget );
	}
	 
	// Return the updated string with ALL the target strings
	// replaced out with the new substring.
	return( strText );
}
function sortByDesc(a, b) {
    var x = a["desc"].toLowerCase();
    var y = b["desc"].toLowerCase();
    return ((x < y) ? -1 : ((x > y) ? 1 : 0));
}
function dump(arr,level) {
	var dumped_text = "";
	if(!level) level = 0;
	
	//The padding given at the beginning of the line.
	var level_padding = "";
	for(var j=0;j<level+1;j++) level_padding += "    ";
	
	if(typeof(arr) == 'object') { //Array/Hashes/Objects 
		for(var item in arr) {
			var value = arr[item];
			
			if(typeof(value) == 'object') { //If it is an array,
				dumped_text += level_padding + "'" + item + "' ...\n";
				dumped_text += dump(value,level+1);
			} else {
				dumped_text += level_padding + "'" + item + "' => \"" + value + "\"\n";
			}
		}
	} else { //Stings/Chars/Numbers etc.
		dumped_text = "===>"+arr+"<===("+typeof(arr)+")";
	}
	return dumped_text;
}
function includeCSS(p_file) {
	var v_css  = document.createElement('link');
	v_css.rel = 'stylesheet'
	v_css.type = 'text/css';
	v_css.href = p_file;
	document.getElementsByTagName('head')[0].appendChild(v_css);
}
includeCSS("JsFloorMap/menu.css");
function JsFloorMap(elementId, store, configArray) {
	this.elementId = elementId;
	this.store = store;
	// jos parametrina ei saatu config arraytä, luodaan tyhjä array
	this.configArray = (configArray !== undefined) ? configArray : {};
	// jos ei määritelty, annetaan vakioarvot   
	this.width = (this.configArray["width"] !== undefined) ? this.configArray["width"]
			: 760;
	this.height = (this.configArray["height"] !== undefined) ? this.configArray["height"]
			: 560;
	this.nro = JsFloorMap.karttaNro();
	this.floorArray = new Array();
	this.uiArray = new Array();
	this.areas = new Array();
	this.links = new Array();
	this.polygons = new Array();
	this.areasLoaded = new Array();
	this.linksLoaded = new Array();
	this.floorsLoaded = new Array();
	this.polygonsLoaded = new Array();
	this.elementReady = false;
	this.filesReady = false;
	this.storeCallbackGot = false;
	this.raphaelSupport = ($.browser.msie && $.browser.version >= 5) || window.SVGAngle;
	this.jg = null;
	this.lastHilight = {};
	this.hilighted = {};
	// korotetaan instanssinumeroa seuraavaa varten
	JsFloorMap.korotaNro();
	// jos tämä on ensimmäinen instanssi
	if (this.nro == 0) {
		// alustetaan staattinen instanssitaulukko
		JsFloorMap.instances = new Array();
	}
	// lisätään tämä instanssi staattiseen taulukkoon
	JsFloorMap.instances[this.nro] = this;
	// kun elementti johon kartta sisällytetään tulee valmiiksi, laukaistaan init funktio
	YAHOO.util.Event.onAvailable(this.elementId, function() {
		this.setElementReady();
	}, this, true);
	
	// laitetaan kaupan csv:t latautumaan
	$.get(
		"JsFloorMap/stores/" + this.store + "/store.csv",
		{r: Math.random()}, // satunnainen parametri estää cacheamisen
		new Function(
			"data",
			"JsFloorMap.getInstance(" + this.nro + ").storeCallback(data);"
		)
	);
	$.get(
		"JsFloorMap/stores/" + this.store + "/ui.csv",
		{r: Math.random()}, // satunnainen parametri estää cacheamisen
		new Function(
			"data",
			"JsFloorMap.getInstance(" + this.nro + ").uiCallback(data);"
		)
	);
	this.uiCallback = function (uiCsv) {
		uiCsvArray = CSVToArray(uiCsv);
		for (key in uiCsvArray) {
			this.uiArray[uiCsvArray[key][0]] = uiCsvArray[key][1];
		}
		// jos määritelty kieli
		if ((this.configArray["lang"] !== undefined)) {
			// laitetaan kielicsv latautumaan
			$.get(
				"JsFloorMap/stores/" + this.store + "/store_" + this.configArray["lang"] + ".csv",
				{r: Math.random()}, // satunnainen parametri estää cacheamisen
				new Function(
					"data",
					"JsFloorMap.getInstance(" + this.nro + ").uiLangCallback(data);"
				)
			);
		}
	}
	this.uiLangCallback = function (langUiCsv) {
		languiCsvArray = CSVToArray(langUiCsv);
		for (key in languiCsvArray) {
			this.uiArray[languiCsvArray[key][0]] = languiCsvArray[key][1];
		}
	}
	this.storeCallback = function (floorCsv) {
		//alert(floorCsv);
		floorCsvArray = CSVToArray(floorCsv);
		for (floor in floorCsvArray) {
			this.floorArray[floorCsvArray[floor][0]] = {
				num: floorCsvArray[floor][1],
				desc: floorCsvArray[floor][2], 
				areas: floorCsvArray[floor][3], 
				links: floorCsvArray[floor][4],
				polygons: floorCsvArray[floor][5],
				baseImage: floorCsvArray[floor][6]
			};
		}
		//alert(this.floorArray[0]);
		for (floor in this.floorArray) {
			// alustetaan kerroksen taulukot
			this.floorsLoaded[floor] = false;
			this.areas[floor] = new Array();
			this.links[floor] = new Array();
			this.polygons[floor] = new Array();
			this.areasLoaded[floor] = false;
			this.linksLoaded[floor] = false;
			this.polygonsLoaded[floor] = false;
			// start data downloads for this floor
			$.get(
				"JsFloorMap/stores/" + this.store + "/" + this.floorArray[floor]["areas"],
				{r: Math.random()}, // satunnainen parametri estää cacheamisen
				new Function(
					"data",
					"JsFloorMap.getInstance(" + this.nro + ").areasCallback(" + floor + ", data);"
				)
			);
			$.get(
				"JsFloorMap/stores/" + this.store + "/" + this.floorArray[floor]["links"],
				{r: Math.random()}, // satunnainen parametri estää cacheamisen
				new Function(
					"data",
					"JsFloorMap.getInstance(" + this.nro + ").linksCallback(" + floor + ", data);"
				)
			);
			$.get(
				"JsFloorMap/stores/" + this.store + "/" + this.floorArray[floor]["polygons"],
				{r: Math.random()}, // satunnainen parametri estää cacheamisen
				new Function(
					"data",
					"JsFloorMap.getInstance(" + this.nro + ").polygonsCallback(" + floor + ", data);"
				)
			);
		}
		this.storeCallbackGot = true;
	}
	this.areasCallback = function (floor, data) {
		areaArray = CSVToArray(data);
		area = 0;
		for (area = 0; area < areaArray.length; area++) {
			this.areas[floor][areaArray[area][0]] = {
				num: areaArray[area][1], 
				desc: areaArray[area][2], 
				baseColor: areaArray[area][3], 
				hilightColor: areaArray[area][4],
				polygons: new Array(1)
			};
		}
		//alert(dump(this.areas[floor]));
		this.areasLoaded[floor] = true;
		this.initFloorIfReady(floor);
	}
	this.linksCallback = function (floor, data) {
		this.links[floor] = CSVToArray(data);
		this.linksLoaded[floor] = true;
		this.initFloorIfReady(floor);
	}
	this.polygonsCallback = function (aFloor, aData) {
		// muunnetaan taulukkodata indeksoiduksi
		polygonsCsvArray = CSVToArray(aData);
		for (key in polygonsCsvArray) {
			this.polygons[aFloor][polygonsCsvArray[key][0]] = polygonsCsvArray[key][1];
		}
		this.polygonsLoaded[aFloor] = true;
		this.initFloorIfReady(aFloor);
	}
	this.floorLangCallback = function (floor, data) {
		langArray = CSVToArray(data);
		for (i in langArray) {
			//alert(dump(langArray[i][0]));
			this.areas[floor][langArray[i][0]]["desc"] = langArray[i][1];
		}
	}
	this.floorDeptList = function(floor, mouseovers) {
		// kerroksen osastolista
		deptListTable = document.getElementById("JsFloorMapDeptTable");
		// poistetaan edellisen kerroksen elementit
		if (deptListTable.hasChildNodes()) {
		    while (deptListTable.childNodes.length >= 1) {
		    	deptListTable.removeChild(deptListTable.firstChild);       
		    } 
		}
		// otsikkorivi
		var deptListTRow = document.createElement('tr');
		deptListTable.appendChild(deptListTRow);
		var deptListTTh = document.createElement('th');
		deptListTRow.appendChild(deptListTTh);
		deptListTTh.setAttribute("colSpan", 2);
		deptListTTh.style["textAlign"] = "center";
		deptListTTh.style["padding"] = "2px 0 8px 0";
		deptListTTh.appendChild(document.createTextNode(this.floorArray[floor]["desc"]));
		// osastot1
		for (area in this.areas[floor]) {
			var deptListTRow = document.createElement('tr');
			deptListTable.appendChild(deptListTRow);
			deptListTRow.style["cursor"] = "default";
			if (mouseovers) {
				deptListTRow.onmouseover = new Function(
						'JsFloorMap.getInstance(' + this.nro + ').hilight(' + floor + ', "' + area + '");');
			}
			var deptListTTd = document.createElement('td');
			deptListTRow.appendChild(deptListTTd);
			deptListTTd.appendChild(document.createTextNode(this.areas[floor][area]["num"]));
			deptListTTd.style["padding"] = "2px 2px 2px 2px";
			deptListTTd.style["lineHeight"] = "12pt";
			var deptListTTd = document.createElement('td');
			deptListTRow.appendChild(deptListTTd);
			deptListTTd.appendChild(document.createTextNode(this.areas[floor][area]["desc"]));
			deptListTTd.style["padding"] = "2px 0 2px 2px";
			deptListTTd.style["lineHeight"] = "12pt";
			this.areas[floor][area]["listElement"] = deptListTTd;
			deptListTTd.style["width"] = "100%";
		}
	}
	this.showFloor = function(floor, mouseovers) {

		this.floorDeptList(floor, mouseovers);
		// vahdetaan kerroksen nappulan väri
		var panelButton = document.getElementById("JFM_panel_" + floor);
		panelButton.style["background"] = "#d3d3df";
		panelButton.style["color"] = "black";
		// palautetaan muiden kerrosten nappuloiden perusväri
		for (otherfloor in this.floorArray) {
			if (otherfloor != floor) {
				var panelButton = document.getElementById("JFM_panel_" + otherfloor);
				panelButton.style["background"] = "#f1edea";
				panelButton.style["color"] = "#7f7f7f";
			}
		}
		canvas = document.getElementById("JsFloorMapCanvas")
		// poistetaan edellisen kerroksen elementit
		if (canvas.hasChildNodes()) {
		    while (canvas.childNodes.length >= 1) {
		    	canvas.removeChild(canvas.firstChild);       
		    } 
		}
		//alert(dump(this.floorArray[floor]));
		//alert(dump(this.areas));
		//alert(dump(this.uiArray));
		// selain on ie 5+ tai svg on tuettu. käytetään raphael:iä
		if (this.raphaelSupport) {
		//if (false) { // jsg renderöinnin testausta varten
			
			var paper = Raphael(canvas, 530, 530);

			var c = paper.image("JsFloorMap/stores/" + this.store + "/" + this.floorArray[floor]["baseImage"], 0, 0, 530, 530);
			paper.image("JsFloorMap/stores/" + this.store + "/" + this.floorArray[floor]["baseImage"].replace(".png", "_overlay.png"), 0, 0, 530, 530);
			for (area in this.areas[floor]) {
				this.areas[floor][area]["rPolygons"] = new Array();
				for (polygon in this.areas[floor][area]["polygons"]) {
					// muunnetaan csv:stä peräisin oleva koordinaattilistaus svg path muotoon
					svgPath = "M " + this.areas[floor][area]["polygons"][polygon].replaceAll(";", " L ");
					// piirrettään polygoni
					rPolygon = paper.path( {
							fill : this.areas[floor][area]["baseColor"],
							//stroke : "#f88",
							opacity : 0.6
						}, svgPath);
					rPolygon.node.onmouseover = new Function(
							'JsFloorMap.getInstance(' + this.nro + ').hilight(' + floor + ', "' + area + '");');
					// otetaan polygoni talteen
					this.areas[floor][area]["rPolygons"].push(rPolygon);
					// raamit erikseen jotta saadaan erillinen läpinäkyvyys
					/*paper.path( {
						fill : "none",
						stroke : "#000",
						opacity : 0.8
					}, svgPath);*/
				}
			}
			
		}
		else {
			this.hilighted[floor] = false;
			// imagemap mouseovereita varten
			var imagemap = document.createElement('map');
			imagemap.setAttribute("name", "karttamap");
			// muunnetaan csv:stä löytyvä koordinaattilistaus image map muotoon
			// ja erilliseksi x ja y koordinaattitaulukoiksi
			var xdashy = new Array();
			var xCoords = new Array();
			var yCoords = new Array();
			var xyArray = new Array();
			var imagemapStr = "";
			for (area in this.areas[floor]) {
				this.areas[floor][area]["jPolygons"] = {};
				for (polygon in this.areas[floor][area]["polygons"]) {
					// csv:stä löytyvästä polygonistringistä koordinaattipareista taulukko
					xdashy = this.areas[floor][area]["polygons"][polygon].split(";");
					xCoords = [];
					yCoords = [];
					xyArray = [];
					imagemapStr = "";
					for (pair in xdashy) {
						// puolitetaan koordinaattiparit
						xyArray = xdashy[pair].split(",");
						xCoords[pair] = parseInt(xyArray[0]);
						yCoords[pair] = parseInt(xyArray[1]);
						// imagemapstringin kirjoitus koordinaateista
						imagemapStr += xdashy[pair];
						if (pair < xdashy.length - 1) {
							imagemapStr += ",";
						}
					}
					
					// luodaan polygonia vastaava imagemapi area
					var areaObj = document.createElement('area');
					areaObj.setAttribute("shape", "poly");
					areaObj.setAttribute("coords", imagemapStr);
					// mouseover eventtiin bindaus
					areaObj.setAttribute("onmouseover", "JsFloorMap.getInstance("
							+ this.nro + ").hilight(" + floor + ", '" + area + "');");
					imagemap.appendChild(areaObj);
					// otetaan jsg polygonin hilightaukseen tarvittavat hommat talteen
					this.areas[floor][area]["jPolygons"][polygon] = {};
					this.areas[floor][area]["jPolygons"][polygon]["xCoords"] = xCoords;
					this.areas[floor][area]["jPolygons"][polygon]["yCoords"] = yCoords;
					this.areas[floor][area]["jPolygons"][polygon]["areaObj"] = areaObj;
				}
				
			}
			// lisätään mappi käytettävään diviin
			var mapDiv = document.getElementById("JsFloorMapCanvas");
			mapDiv.appendChild(imagemap);
			
			// alert(csvArray[area][0]);
			var bgImg = document.createElement('img');
			bgImg.setAttribute("src", "JsFloorMap/stores/" + this.store + "/" + this.floorArray[floor]["baseImage"]);
			// <img src="wiklund/pohja_50.png" usemap="#karttamap"
			// style="border: medium none ;" height="600" width="600">
			bgImg.setAttribute("usemap", "#karttamap");
			bgImg.setAttribute("style",
							"border: none; position: absolute; left: 0; top: 0;");
			bgImg.setAttribute("height", 530);
			bgImg.setAttribute("width", 530);
			mapDiv.appendChild(bgImg);
			
			// overlay kuva
			var symbolsImg = document.createElement('img');
			mapDiv.appendChild(symbolsImg);
			symbolsImg.setAttribute("src", "JsFloorMap/stores/" + this.store + "/" + this.floorArray[floor]["baseImage"].replace(".png", "_overlay.png"));
			symbolsImg.setAttribute("style",
			"z-index: 10; border: none; position: absolute; left: 0; top: 0;");
			symbolsImg.setAttribute("height", 530);
			symbolsImg.setAttribute("width", 530);
			var overlayImg = document.createElement('img');
			mapDiv.appendChild(overlayImg);
			overlayImg.setAttribute("src", "JsFloorMap/stores/" + this.store + "/" + this.floorArray[floor]["baseImage"].replace(".png", "_50.png"));
			overlayImg.setAttribute("usemap", "#karttamap");
			overlayImg.setAttribute("style",
							"z-index: 10; border: none; position: absolute; left: 0; top: 0;");
			overlayImg.setAttribute("height", 530);
			overlayImg.setAttribute("width", 530);
			this.jg = new jsGraphics("JsFloorMapCanvas");
			this.resetHilight(floor);
			this.jg.paint();
		}
	}
	this.initMapIfReady = function() {
		// jos elementti jonka sisään kartta piirretään on valmis
		if (this.elementReady && this.storeCallbackGot) {
			// tarkastetaan, että kaikki kerrokset on ladattu
			var ready = true;
			for (floor in this.floorArray) {
				if (!this.floorsLoaded[floor]) {
					ready = false;
					//break;
				}
			}
			// jos kaikki kerrokset on ladattu
			if (ready) {
				// aakkosellinen osastolista
				// teksti dropdowniin
				var ascDeptListSpan = document.getElementById("ascDeptListSpan");
				//ascDeptListSpan.appendChild(document.createTextNode(this.uiArray["osastot"]));
				
				// osastolista aakkosjärjestykseen
				var areasRandom = new Array();
				for (floor in this.areas) {
					for (area in this.areas[floor]) {
						dept = {}
						dept["desc"] = this.areas[floor][area]["desc"];
						dept["floor"] = floor;
						dept["id"] = area;
						areasRandom.push(dept);
					}
				}
				//alert(dump(areasRandom.sort(sortByDesc)));
				var areasAsc = areasRandom.sort(sortByDesc);
				
				var osastotData = new Array();
				for (i in areasAsc) {
					osastotData.push(
						{ 
							text: areasAsc[i]["desc"], 
							onclick: { 
								fn: JsFloorMap.showDept, 
								obj: {
									inst: "" + this.nro, 
									floor: "" + areasAsc[i]["floor"], 
									area: "" + areasAsc[i]["id"]
								}
							}
						}
					);
				}
				
				var oMenuButton = new YAHOO.widget.Button({ type: "menu", label: this.uiArray["osastot"], name: "deptButton" + this.nro, menu: osastotData, container: "JsFloorMapAscDept" });
				
				// kerroslista
				panelTbody = document.getElementById("JsFloorMapPanelText");
				panelTr = document.createElement('tr');
				panelTbody.appendChild(panelTr);
				panelTh = document.createElement('th');
				panelTr.appendChild(panelTh);
				panelTh.style["fontWeight"] = "normal";
				panelTh.style["padding"] = "0 20px 0 0";
				panelTh.style["verticalAlign"] = "middle";
				panelTh.appendChild(document.createTextNode(this.uiArray["kerrokset"]));
				var floor = 0;
				for (floor in this.floorArray) {
					var panelTd = document.createElement('td');
					panelTr.appendChild(panelTd);
					panelTd.setAttribute("id", "JFM_panel_" + floor);
					panelTd.style["background"]= "#f1edea";
					panelTd.style["color"]= "#7f7f7f";
					panelTd.style["border"]= "1px solid #a6a6a6";
					panelTd.style["verticalAlign"] = "middle";
					panelTd.style["height"]= "20px";
					panelTd.style["padding"]= "0";
					panelTd.style["width"]= "22px";
					panelTd.style["textAlign"]= "center";
					panelTd.onclick = new Function(
							'JsFloorMap.getInstance(' + this.nro + ').showFloor(' + floor + ');');
					panelTd.style["cursor"] = "pointer";
					panelTd.style["cursor"] = "hand";
					panelTd.appendChild(document.createTextNode(this.floorArray[floor]["num"]));
				}
				//alert("Huom. Tämä on kehitysversio, muutokset mahdollisia.\n\n©Ade Oy");
				this.showFloor(1, true);
			}
		}
	}
	this.initFloorIfReady = function (floor) {
		// jos kerroksen kaikki csv:t on haettu
		if (this.areasLoaded[floor] && this.linksLoaded[floor] && this.polygonsLoaded[floor]) {
			// jos määritelty kieli
			if ((this.configArray["lang"] !== undefined)) {
				// laitetaan kielicsv latautumaan
				$.get(
					"JsFloorMap/stores/" + this.store + "/" + this.floorArray[floor]["areas"].replace(".csv", "_" + this.configArray["lang"] + ".csv"),
					new Function(
						"data",
						"JsFloorMap.getInstance(" + this.nro + ").floorLangCallback(" + floor + ", data);"
					)
				);
			}
			// lisätään linkkien mukaiset polygonit tämän kerroksen areoihin
			for (link in this.links[floor]) {
				//alert(this.areas[floor] [this.links[floor][link][0]]);
				this.areas[floor][this.links[floor][link][0]]["polygons"].push(this.polygons[floor][this.links[floor][link][1]]);
			}
			this.floorsLoaded[floor] = true;
			JsFloorMap.getInstance(this.nro).initMapIfReady();
		}
		
	}
	this.setElementReady = function() {
		// tehdään layoutti sovellusta varten
		var mapDiv = document.getElementById(this.elementId);
		mapDiv.setAttribute("class", "JsFloorMap");
		mapDiv.style["height"] = this.height + "px";
		mapDiv.style["width"] = this.width + "px";
		mapDiv.style["fontSize"] = "12pt";
		
		// paneeli
		var panelDiv = document.createElement('div');
		mapDiv.appendChild(panelDiv);
		panelDiv.setAttribute("id", "JsFloorMapPanel");
		//panelDiv.style["position"] = "relative";		
		panelDiv.style["width"] = this.width + "px";
		panelDiv.style["height"] = "26px";
		panelDiv.style["padding"] = 0;
		panelDiv.style["margin"] = 0;
		panelDiv.style["color"] = "white";
		//panelDiv.style["border"] = "1px solid black";
		panelDiv.style["background"] = "url('JsFloorMap/uiImg/panelBg.png') no-repeat";
		var panelTable = document.createElement('table');
		panelDiv.appendChild(panelTable);
		panelTable.style["width"] = "auto";
		if ($.browser.msie) {
			panelTable.style["margin"] = "2px 0 0 6px";
		}
		else {
			panelTable.style["margin"] = "3px 0 0 6px";
		}
		panelTbody = document.createElement('tbody');
		panelTable.appendChild(panelTbody);
		panelTbody.setAttribute("id", "JsFloorMapPanelText");
		

		
		// osastolista

		var ascDeptList = document.createElement('div');
		panelDiv.appendChild(ascDeptList);
		ascDeptList.setAttribute("id", "JsFloorMapAscDept")
		ascDeptList.style["margin"] = "-22px 0 0 500px";
		ascDeptList.setAttribute("class", "JsFloorMapDeptBt");
		
		// piirtoalue
		var canvasDiv = document.createElement('div');
		mapDiv.appendChild(canvasDiv);
		canvasDiv.setAttribute("id", "JsFloorMapCanvas");
		
		canvasDiv.style["position"] = "relative";

		canvasDiv.style["left"] = "0";
		canvasDiv.style["width"] = "530px";
		canvasDiv.style["height"] = "530px";
		canvasDiv.style["margin"] = "4px 0 0 0";
		//canvasDiv.style["border"] = "1px dotted black";
		
		// osastolista
		var deptListDiv = document.createElement('div');
		mapDiv.appendChild(deptListDiv);
		deptListDiv.setAttribute("id", "JsFloorMapDeptList");

		deptListDiv.style["position"] = "relative";
		deptListDiv.style["margin"] = "-504px 0 0 0";
		deptListDiv.style["left"] = "546px";
		deptListDiv.style["width"] = "214px";
		deptListDiv.style["padding"] = "0";
		//deptListDiv.style["height"] = "530px";
		//deptListDiv.style["margin"] = "4px 0 0 0";
		deptListDiv.style["background"] = "url('JsFloorMap/uiImg/deptListBgTop.png') no-repeat";
		//deptListDiv.style["border"] = "1px dotted green";
		
		var deptListTableContDiv = document.createElement('div');
		deptListDiv.appendChild(deptListTableContDiv);
		deptListTableContDiv.style["padding"] = "0 0 20px 0";
		deptListTableContDiv.style["background"] = "url('JsFloorMap/uiImg/deptListBgBottom.png') no-repeat bottom";
		deptListTableContDiv.style["width"] = "214px";
		
		var deptListTable = document.createElement('table');
		deptListTableContDiv.appendChild(deptListTable);
		//deptListTable.style["height"] = "214px";
		deptListTable.style["margin"] = "4px 0 0 3px";
		deptListTable.style["width"] = "210px";
		
		var deptListTBody = document.createElement('tbody');
		deptListTable.appendChild(deptListTBody);
		deptListTBody.setAttribute("id", "JsFloorMapDeptTable");
		deptListTBody.style["padding"] = "3px 0 0 3px";
		
		
		
		// tallennetaan elementin valmius
		this.elementReady = true;
		// laukaistaan mapin initointi
		this.initMapIfReady();
	}
	this.hilight = function(floor, area) {
		this.areas[floor][area]["listElement"].style["background"] = this.areas[floor][area]["hilightColor"];
		for (otherArea in this.areas[floor]) {
			if (otherArea != area) {
				this.areas[floor][otherArea]["listElement"].style["background"] = "transparent";
			}
		}
		if (this.raphaelSupport) {
			// hilightataan tämän osaston polygoonit
			for (polygon in this.areas[floor][area]["rPolygons"]) {
				this.areas[floor][area]["rPolygons"][polygon].animate( {
					fill : this.areas[floor][area]["hilightColor"],
					opacity : 0.6
				}, 10);
			}
			// poistetaan muiden osastojen hilightit
			for (otherArea in this.areas[floor]) {
				if (otherArea != area) {
					for (polygon in this.areas[floor][otherArea]["rPolygons"]) {
						this.areas[floor][otherArea]["rPolygons"][polygon].animate( {
							fill : this.areas[floor][otherArea]["baseColor"],
							opacity : 0.6
						}, 50);
					}
				}
			}
		}
		else {
			for (polygon in this.areas[floor][area]["jPolygons"]) {
				this.areas[floor][area]["jPolygons"][polygon]["areaObj"].setAttribute("onmouseover", "");
				i = 0;
				while (hilightattava = document.getElementById("JFM" + floor + "_" + area + "_" + polygon  + "_" + i)) {
					hilightattava.style["backgroundColor"] = this.areas[floor][area]["hilightColor"];
					i++;
				}
			}
			if (this.hilighted[floor] && this.lastHilight[floor] != area) {
				// poistetaan edellisen hilightatun osaston hilight ja palautetaan mouseoveri
				for (polygon in this.areas[floor][this.lastHilight[floor]]["jPolygons"]) {
					i = 0;
					while (dehilightattava = document.getElementById("JFM" + floor + "_" + this.lastHilight[floor] + "_" + polygon  + "_" + i)) {
						dehilightattava.style["backgroundColor"] = this.areas[floor][this.lastHilight[floor]]["baseColor"];
						i++;
					}
					this.areas[floor][this.lastHilight[floor]]["jPolygons"][polygon]["areaObj"].setAttribute(
							"onmouseover",
							"JsFloorMap.getInstance(" + this.nro + ").hilight(" + floor + ", '" + this.lastHilight[floor] + "');");
				}
			}

			this.hilighted[floor] = true;
		}
		this.lastHilight[floor] = area;
	}
	this.floorDeptSmartEnable = function(floor) {
		//alert("mouseOffRegistered");
		// kerroksen osastolista
		var deptListTable = document.getElementById("JsFloorMapDeptList");
		var funct = "";
		funct += "if (!e) var e = window.event;";
		funct += "var tg = (window.event) ? e.srcElement : e.target;";
		funct += "if (tg.nodeName == 'DIV') return;";
		funct += "var reltg = (e.relatedTarget) ? e.relatedTarget : e.toElement;";
		funct += "if (reltg.nodeName == 'TD') return;";
		funct += "JsFloorMap.getInstance(" + this.nro + ").rmFloorDeptSmartEnable();";
		funct += "JsFloorMap.getInstance(" + this.nro + ").floorDeptList(" + floor + ", true);";
		funct += "JsFloorMap.getInstance(" + this.nro + ").hilight(" + floor + ", '" + this.lastHilight[floor] + "');"
		deptListTable.onmouseout = new Function('e', funct);
				//"JsFloorMap.getInstance(" + this.nro + ").floorDeptList(" + floor + ", true); alert('foo')");

	}
	this.rmFloorDeptSmartEnable = function() {
		var deptListTable = document.getElementById("JsFloorMapDeptList");
		deptListTable.onmouseout = null;
	}
	this.resetHilight = function(floor) {
		//this.jg.clear();
		// käydään kaikki kerroksen polygonit läpi
		for (area in this.areas[floor]) {
			// asetetaan väriksi tämän osaston perusväri
			this.jg.setColor(this.areas[floor][area]["baseColor"]);
			// piirretään jokainen polygoni
			for (polygon in this.areas[floor][area]["jPolygons"]) {
				this.jg.fillPolygon(
					this.areas[floor][area]["jPolygons"][polygon]["xCoords"],
					this.areas[floor][area]["jPolygons"][polygon]["yCoords"],
					"JFM" + floor + "_" + area + "_" + polygon
				);
			}
		}
	}
}
JsFloorMap.getInstance = function (number) {
	return JsFloorMap.instances[number];
}
JsFloorMap.showDept = function (a, b, c) {
	JsFloorMap.getInstance(c["inst"]).showFloor(c["floor"], false);
	JsFloorMap.getInstance(c["inst"]).hilight(c["floor"], c["area"]);
	JsFloorMap.getInstance(c["inst"]).floorDeptSmartEnable(c["floor"]);
}
JsFloorMap.karttaNro = function() {
	return (typeof JsFloorMap.nro == 'undefined') ? 0 : JsFloorMap.nro;
}
JsFloorMap.korotaNro = function() {
	JsFloorMap.nro = (typeof JsFloorMap.nro == 'undefined') ? 1 : JsFloorMap.nro + 1;
}
JsFloorMap.mouseOff = function(e) {
	if (!e) var e = window.event;
	var tg = (window.event) ? e.srcElement : e.target;
	if (tg.nodeName == 'DIV') return;
	var reltg = (e.relatedTarget) ? e.relatedTarget : e.toElement;
	if (reltg.nodeName == 'TD') return;
	// Mouseout took place when mouse actually left layer
	// Handle event
	alert("yea");
}